<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Booking extends Model 
{

    protected $table = 'bookings';
    public $timestamps = true;

    public function pet()
    {
        return $this->belongsTo('Pet', 'pet_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function service()
    {
        return $this->belongsTo('Service', 'service_id');
    }

    public function branch()
    {
        return $this->belongsTo('Branch', 'branch_id');
    }

    public function booking()
    {
        return $this->belongsTo('Booking', 'booking_id');
    }

}